------------------------------------------------------------
-- Change Composition Depth Globally, Revision: 2.0
--
--
-- This script can set the missing frames options for all loaders.

-- place in Fusion:\Scripts\Comp 
--
-- written by Isaac Guenard (izyk@eyeonline.com) / Sean Konrad
-- created : January 24rd, 2005
------------------------------------------------------------

MissingFramesOpt = {"Fail", "Hold Previous", "Output Black", "Wait"}

ret = AskUser("Change Loader Missing Frames option", {	
	{"MissingFrames",  "Dropdown", Options = MissingFramesOpt},
	{"Selected", Name = "Affect Selected Tools Only", "Checkbox", Default = 0}
	})

if ret then
	print()
	print("Changing Loader Missing Frames to ".. MissingFramesOpt[ret.MissingFrames + 1])
	print("---------------------------------------------------")
	print()

	-- ((ret.Selected ==1)) will return true if the 
	-- selected checkbox is enabled.....
	
	for i, v in pairs(composition:GetToolList((ret.Selected == 1))) do
		id = v:GetAttrs().TOOLS_RegID

		if id == "Loader" then
			v.MissingFrames = ret.MissingFrames
			print(v:GetAttrs().TOOLS_Name)
		end
	end
	
end
print()
